/**
 * Created by lei.wang_1 on 2016/7/15.
 */
appModule.directive("commentItem",["notices","$translate","utils", function(notices,translate,utils){
    return {
        template:'<div class="avatar left">'
            +       '<notice-image isrc="comment.avatar" save-to-local="false" default-src="theme/images/account_default_avatar.png"></notice-image>'
            +    '</div>'
            +    '<div class="right">'
            +       '<div>'
            +           '<div class="name" ng-class="{\'editorPublish\':showEditorStyle}">'
            +               '<span ng-bind="comment.title"></span>'
            +               '<span ng-show="comment.to_user_id" class="toUser" ng-bind="comment.toUser"></span>'
            +               '<span ng-show="showEditorStyle" class="commentType" ng-bind="comment.typeText"></span>'
            +               '<div class="menu">'
            +                   '<a class="reply" ng-click="toggleReply({comment:comment})"><span translate="preview.comment.reply"></span></a>'
            +                   '<span class="splitter" ng-show="canDeleteComment({comment:comment})"></span>'
            +                   '<a class="delete" ng-click="removeComment({comment:comment})" ng-show="canDeleteComment({comment:comment})"><span translate="preview.comment.delete"></span></a>'
            +               '</div>'
            +           '</div>'
            +           '<div class="commentContent">'
            +               '<comment-content content="comment.content"></comment-content>'
            +               '<span ng-bind="comment.createdTime" class="commentTime"></span>'
            +           '</div>'
            +       '</div>'
            +   '</div>',
        restrict: 'E',
        scope:{
            comment:'=',
            boardInfo:"=",
            toggleReply:"&",
            removeComment:"&",
            canDeleteComment:"&",
            isEditorComment:"&"
        },
        link: function ($scope,element) {
            $scope.comment.createdTime = utils.time2str($scope.comment.created_at/1000);
            $scope.noEditorStyle = utils.getUrlParam(window.location.search,'no_editor_style');
            $scope.showEditorStyle = $scope.comment.is_editor && $scope.noEditorStyle != 1;
            $scope.comment.typeText = translate.instant('preview.comment.author') + ($scope.comment.comment_id ? translate.instant('preview.comment.reply-by-editor') : translate.instant('preview.comment.comment-by-editor'));
            if ($scope.comment.is_editor && !$scope.noEditorStyle ) {
                $scope.comment.avatar = $scope.boardInfo.avatar;
                $scope.comment.title = $scope.boardInfo.board_name;
            }else{
                notices.getBasicUserInfo($scope.comment.user_id,function(info){
                    if(info){
                        utils.applyScope($scope,function(){
                            $scope.comment.avatar = info.avatar;
                            $scope.comment.title = info.displayName;
                        });
                    }
                });
            }
            if($scope.comment.to_user_id){
                if(!$scope.noEditorStyle && $scope.isEditorComment({id:$scope.comment.parent_id})){
                    $scope.comment.toUser =translate.instant('preview.comment.reply-to-author');
                }else{
                    notices.getBasicUserInfo($scope.comment.to_user_id,function(info){
                        if(info){
                            utils.applyScope($scope,function(){
                                $scope.comment.toUser =translate.instant('preview.comment.reply-to',{name: info.displayName});
                            });
                        }
                    });
                }
            }
        }
    }
}]);